{* smarty *}
{include file='header.tpl' title=$config.config_site_title description=$config.config_site_description index=1}

<style>
    /* پس‌زمینه کل صفحه */
    body {
        font-family: Tahoma, sans-serif;
        background-color: #d0e7ff; /* آبی کم‌رنگ */
        margin: 0;
        padding: 0;
        color: #000; /* متن اصلی کل سایت */
    }

    /* کانتینر فرم */
    #form-container {
        background: linear-gradient(to bottom right, #0a78ff, #66c2ff);
        padding: 30px;
        border-radius: 20px;
        color: #fff;
        box-shadow: 0 10px 30px rgba(0,0,0,0.5);
        margin: 30px auto;
        max-width: 1200px;
        display: flex;
        justify-content: space-between;
    }

    #form-container h2 {
        color: #ffd700;
        text-shadow: 1px 1px 5px #000;
        margin-bottom: 15px;
    }

    #form-container p, 
    #form-container label, 
    #form-container .highlight {
        color: #ffffff;
        text-shadow: 1px 1px 4px #000;
    }

    #form-container .highlight {
        color: #ffea00;
        font-weight: bold;
    }

    #form-container select.form, 
    #form-container input.form {
        background-color: rgba(255,255,255,0.9);
        color: #000;
        border-radius: 8px;
        padding: 6px 10px;
        margin-bottom: 10px;
        border: none;
        font-size: 1em;
    }

    #form-container .box {
        background-color: rgba(255,255,255,0.1);
        padding: 10px;
        margin-bottom: 15px;
        border-radius: 10px;
    }

    #form-container .box.marg {
        padding: 12px;
    }

    #form-container .bill table {
        width: 100%;
        color: #fff;
        border-collapse: collapse;
    }

    #form-container .bill td {
        padding: 6px 10px;
        border-bottom: 1px solid rgba(255,255,255,0.2);
    }

    #form-container .button {
        display: inline-block;
        background-color: #ff4444;
        color: #fff;
        padding: 6px 14px;
        border-radius: 8px;
        text-decoration: none;
        font-weight: bold;
        margin-left: 10px;
        cursor: pointer;
        transition: background 0.3s;
    }

    #form-container .button:hover {
        background-color: #ff6666;
    }

    #form-container .banks li {
        display: inline-block;
        margin-right: 10px;
    }

    .cleaner {
        clear: both;
    }
</style>

<div id="form-container">
<form method="post" id="meu_formulario">
    <div class="right-div">
        <div>
            <select name="category" id="category" style="width:100%;">
                <option value="0">انتخاب کنید</option>
                {foreach $categories as $category}
                    <option value="{$category.category_id}" {if $category.category_image}title="{$category.category_image}?w=30&h=30"{/if}>{$category.category_title}</option>
                {/foreach}
            </select>
            <div class="cleaner"></div>
        </div>
        <div id="waiting" class="box">{$config.config_operator_description|htmlspecialchars_decode}</div>

        {foreach $categories as $category}
            <div id="product_{$category.category_id}" class="box">
                <ul>
                    {if $category.category_image}
                        <img src="{$category.category_image}?w=100&h=100" align="left" style="margin-right:10px;">
                    {/if}
                    {foreach $category.products as $product}
                        <li>
                            <input type="radio" value="{$product.product_id}" name="card" id="card_{$product.product_id}" {if $product.counter == 0}disabled{/if}>
                            <label for="card_{$product.product_id}">{$product.product_title}</label>
                            <span id="price_{$product.product_id}" style="display: none;">{$product.product_price}</span>
                        </li>
                    {/foreach}
                </ul>
                <div class="cleaner"></div>
            </div>
        {/foreach}

        <div class="box marg">
            تعداد:
            <select name="qty" size="1" class="form" id="qty" style="width:50px">
                <option value="1">۱</option>
                <option value="2">۲</option>
                <option value="3">۳</option>
                <option value="4">۴</option>
                <option value="5">۵</option>
            </select> عدد
        </div>

        <div class="box marg">
            <div class="bill">
                <table>
                    <tr><td width="35%">نوع کارت</td><td><div id="billType">-</div></td></tr>
                    <tr><td>قیمت واحد</td><td><div id="billPrice">-</div></td></tr>
                    <tr><td>تعداد</td><td><div id="billQty">-</div></td></tr>
                    <tr><td>جمع کل</td><td><div id="billTotal">-</div></td></tr>
                </table>
            </div>
        </div>
    </div>

    <div class="left-div">
        <div class="info">
            <h2>اطلاعات تماس</h2>
            <p>ایمیل و شماره تلفن همراه خود را وارد کنید:</p>
            <label for="email">ایمیل:</label>
            <input type="text" name="email" id="email" class="form" dir="ltr" style="width:100%;">
            <label for="mobile">شماره همراه:</label>
            <input type="text" name="mobile" id="mobile" class="form" dir="ltr" style="width:100%;">
        </div>

        <div class="info">
            <h2>اطلاعات پرداخت <span id="loader"></span></h2>
            <label for="gateway">درگاه پرداخت:</label>
            <select name="gateway" id="gateway" class="form" style="width:100%;">
                {foreach $payment_methods as $option}
                    <option value="{$option.plugin_uniq}">{$option.plugin_name}</option>
                {/foreach}
            </select>
            <a onclick="return false;" href="" class="button" id="submit">پرداخت</a>
            <div class="cleaner"></div>
            قابل پرداخت با کارت بانک‌های:
            <ul class="banks">
                {$banks_logo}
            </ul>
        </div>
    </div>
</form>
</div>

<div class="cleaner"></div>

{if $config.config_admin_yahoo_id}
<a referrerpolicy="origin" target="_blank" href="https://trustseal.enamad.ir/?id=6140&amp;Code=VCw4PCBEpHASmz3mh3eM"><img referrerpolicy="origin" src="https://Trustseal.eNamad.ir/logo.aspx?id=6140&amp;Code=VCw4PCBEpHASmz3mh3eM" alt="" style="cursor:pointer" id="VCw4PCBEpHASmz3mh3eM"></a>

</a>
{/if}

{$config.config_description|htmlspecialchars_decode}

<div class="cleaner"></div>
{include file='footer.tpl'}
